<?php
/* Attribute: Anzahl Spalten fr products_options_name */
define('COLSPAN_ATTRIBUTES', 3);
/* Auswahlliste Produkte pro Seite */
$number_of_pages_array = array(1,2,5,10,20,50,100,200,500,1000);

require_once ('includes/application_top.php');
require_once (DIR_FS_INC.'xtc_parse_search_string.inc.php');
require_once (DIR_FS_INC.'xtc_get_tax_class_id.inc.php');
// Define module folder name
define('DIR_WS_MODULE_FOLDER_NAME', DIR_WS_INCLUDES.'extra/modules/stocklist/');
// include the language translations
if (file_exists( DIR_WS_MODULE_FOLDER_NAME.'lang/'.$_SESSION['language'].'/stocklist.php' )){
  include(DIR_WS_MODULE_FOLDER_NAME.'lang/'.$_SESSION['language'].'/stocklist.php');
} else {
  include(DIR_WS_MODULE_FOLDER_NAME.'lang/german/stocklist.php');
}
require_once (DIR_WS_MODULE_FOLDER_NAME.'stocklist_params.php');

$confirm_save_entry = CONFIRM_SAVE_ENTRY == 'true' ? "return confirm('". SAVE_ENTRY ."');" : "";
$customers_statuses_array = xtc_get_customers_statuses();
$error_constants="";
$error_msg="";

set_stocklist_fields();
set_stocklist_params();
$arr_dropdown_search = init_stocklist();
$sorting = (isset($_SESSION['sorting']) ? $_SESSION['sorting'] : 'products_id');

# DATEN SPEICHERN
if(isset($_POST['action']) && $_POST['action']=='save'){
	$sql = save_stocklist_data();
	xtc_redirect(xtc_href_link(FILENAME_STOCKLIST, 'saved='.$sql));
}

# ABFRAGE DATEN
$listing_sql = getStrSqlProducts();
$products_split = new splitPageResults($_SESSION['page'], $_SESSION['paging'], $listing_sql, $products_query_numrows, 'p.products_id');
$products_query = xtc_db_query($listing_sql);

# FEHLERAUSGABE
if (!@constant('MODULE_STOCKLIST_STATUS') || MODULE_STOCKLIST_STATUS != 'True') {
  $messageStack->add(ERROR_STATUS, 'error');
}elseif($error_msg) {
  if($error_constants)
  	$error_msg = sprintf(ERROR_CAPTION, DIR_FS_LANGUAGES . $_SESSION['language'] . '/admin/'.$current_page) . $error_msg;
	$messageStack->add($error_msg, 'error');
}

require (DIR_WS_INCLUDES.'head.php');
?>
<script type="text/javascript" src="includes/javascript/jquery.min.js"></script>
<script type="text/javascript" src="includes/extra/modules/stocklist/javascript/stocklist.js"></script>
<link rel="stylesheet" type="text/css" href="includes/extra/modules/stocklist/stocklist.css" />
<?php
//jQueryDatepicker
require (DIR_WS_INCLUDES.'javascript/jQueryDatepicker/datepicker.js.php');
?>
</head>
<body style="margin: 0; background-color: #FFFFFF">
<div id="spiffycalendar" class="text"></div>
		<!-- header //-->
		<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
		<!-- header_eof //-->
		<!-- body //-->
		<table style="border:none; width:100%;" cellspacing="2" cellpadding="2">
			<tr>
				<td class="columnLeft2" width="<?php echo BOX_WIDTH; ?>" valign="top">

      <?php //left_navigation
      if (USE_ADMIN_TOP_MENU == 'false') {
        echo '<td class="columnLeft2">'.PHP_EOL;
        echo '<!-- left_navigation //-->'.PHP_EOL;
        require_once(DIR_WS_INCLUDES . 'column_left.php');
		if (!@constant('MODULE_STOCKLIST_STATUS') || MODULE_STOCKLIST_STATUS != 'True')
			exit;		
        echo '<!-- left_navigation eof //-->'.PHP_EOL;
        echo '</td>'.PHP_EOL;
      }
      ?>
	 				
				</td>
				<!-- body_text //-->
				<td class="boxCenter" width="100%" valign="top">
          <?php
					# column_left.php: $admin_access
					define('EDIT_MODE', ($admin_access['stocklist_edit'] == '1'));
					define('CONFIG_MODE', ($admin_access['stocklist_config'] == '1'));
					if(isset($_REQUEST['access']) && EDIT_MODE) {
					  $_SESSION['access'] = $_REQUEST['access'];
					} elseif(!isset($_SESSION['access'])) {
					  $_SESSION['access'] = 0;
					}
					echo xtc_draw_form('stocklist', FILENAME_STOCKLIST);
					echo xtc_draw_hidden_field('search', $_SESSION['search']);
					echo xtc_draw_hidden_field('page', $_SESSION['page']);
					echo xtc_draw_hidden_field('sorting', $_SESSION['sorting']);
					echo xtc_draw_hidden_field('action', '');
					?>

		<div class="pageHeadingImage"><?php echo xtc_image(DIR_WS_ICONS.'heading/icon_configuration.png'); ?></div>
        <div class="pageHeading"><?php echo HEADING_TITLE_STOCKLS; ?></div>       
        <div class="main pdg2 flt-l"><?php echo HEADING_TITLE_STOCKLS2; ?><br />&nbsp;</div>
					
					<table border="0" cellspacing="0" cellpadding="0">

	          <tr>
	            <td class="pageHeading">
							
							</td>
	            <td class="dataTableHeadingContent">
                <div style="position:relative;top:0px;">
								<?php
								for($i=0; $i < count($number_of_pages_array); $i++){
								 $pages_array[] = array('id' => $number_of_pages_array[$i], 'text' => sprintf(TEXT_PAGES, $number_of_pages_array[$i]));
								}
								echo xtc_draw_pull_down_menu('total_paging', $pages_array, $_SESSION['paging'], 'onChange="this.form.submit();"');
               ?>
							 </div>
							</td>
	            <td class="dataTableHeadingContent" style="text-align:right">
                <div id="div_search" style="position:relative;width:430px;top:15px;">
								<?php
								echo '<div class="dropdown_typ">' . xtc_draw_pull_down_menu('searchtyp', $arr_dropdown_search, $_SESSION['searchtyp'], ' id="searchtyp" onChange="checkSearchTyp(this.form, this.value);"').'</div>';
								echo '<div class="dropdown_data" style="visibility:'.($FLD_SELECTED?'hidden':'visible').';" id="div_search_value">' . xtc_draw_input_field('search_value', $_SESSION['search_value'], 'style="width: 200px;"').'</div>';
								for($i=0; $i < count($CONFIG_DROPDOWN); $i++){
									$field = $CONFIG_DROPDOWN[$i];
									$dropdownField = "dropdown_".$field;
                  if(is_array($$dropdownField)){
										echo '<div  class="dropdown_data" style="visibility:'.($FLD_SELECTED==$field?'visible':'hidden').';" id="div_search_'.$field.'">' .  xtc_draw_pull_down_menu('search_'.$field, $$dropdownField, $_SESSION['search_'.$field], ' id="search_'.$field.'" style="width: 200px;" onChange="document.forms[\'stocklist\'].action.value=\'search\';this.form.submit();"').'</div>';
									}
								}
							 ?>
               <div class="dropdown_search"><input style="padding-top:0px; margin-top:0px; height:20px" class="button" name="btn_submit" onClick="document.forms['stocklist'].action.value='search';this.blur();" value="<?php echo BUTTON_SEARCH; ?>" type="submit"></div>
							 </div>
							</td>

							<?php if(EDIT_MODE){ ?>
	            <td class="dataTableHeadingContent">
	              <?php
								$access_array[] = array('id' => 0, 'text' => TEXT_SHOW);
								$access_array[] = array('id' => 1, 'text' => TEXT_EDIT);
								echo xtc_draw_pull_down_menu('access', $access_array, $_SESSION['access'], 'onChange="this.form.submit();"');
							 ?>
							</td>
							<?php } ?>

							<?php if(EDIT_MODE && $_SESSION['access']){ ?>
							<td class="dataTableHeadingContent">
               <input style="padding-top:0px; margin-top:0px; height:20px" class="button" name="btn_submit" onClick="document.forms['stocklist'].action.value='save';<?php echo $confirm_save_entry; ?>" value="<?php echo BUTTON_SAVE_CHANGES; ?>" type="submit">
              </td>
							<?php } ?>
							<td class="dataTableHeadingContent">
               <a input style="padding-top:0px; margin-top:0px; height:13px" class="button" onClick="this.blur();" href="stocklist_config.php"><?php echo BUTTON_CONFIG; ?></a>
              </td>

	          </tr>
	          </table>

	          <table border="0" cellspacing="0" cellpadding="0" width="100%">
	          <tr>
	            <td colspan="<?php echo (6 + EDIT_MODE); ?>" width="100%">
								<table width="100%" cellspacing="0" cellpadding="2">
				         <!-- close tables from above modules //-->
				         <tr class="dataTableHeadingRow">
								<?php
								echo '<td class="dataTableHeadingContent" style="text-align:center; min-width:45px">';
								echo "<span title='". HEADING_PRODUCTS_PRODUCTS_ID ."'>".HEADING_PRODUCTS_PRODUCTS_ID."</span>";
								echo xtc_sorting(FILENAME_STOCKLIST,'products_id', $PARAMS_URL."&paging=".$_SESSION['paging']);
								echo '</td>';
								echo '<td class="dataTableHeadingContent">';
								echo "<span title='". HEADING_PRODUCTS_PRODUCTS_NAME ."'>".HEADING_PRODUCTS_PRODUCTS_NAME."</span>";
								echo xtc_sorting(FILENAME_STOCKLIST,'products_name', $PARAMS_URL."&paging=".$_SESSION['paging']);
								echo '</td>';
								echo '<td class="dataTableHeadingContent">';
								echo "<span title='". HEADING_PRODUCTS_PRODUCTS_IMAGE ."'>".HEADING_PRODUCTS_PRODUCTS_IMAGE."</span>";
								echo '</td>';

								for($i=0; $i < count($CONFIG_FIELDS[TABLE_PRODUCTS]); $i++){
                  if($CONFIG_FIELDS[TABLE_PRODUCTS][$i]['status']){
										$field = $CONFIG_FIELDS[TABLE_PRODUCTS][$i]['field'];
									  $caption = $CONFIG_FIELDS[TABLE_PRODUCTS][$i]['caption'];
									  $align= $CONFIG_FIELDS[TABLE_PRODUCTS][$i]['align'];
				  					$style = !empty($align)?'text-align:'.$align.';':'';
										echo '<td class="dataTableHeadingContent" style="'.$style.'">';
										echo "<span title='". $caption ."'>".$caption."</span>";
										echo xtc_sorting(FILENAME_STOCKLIST, $field, $PARAMS_URL."&paging=".$_SESSION['paging']);
										echo '</td>';
									}
								}
			    			echo '</tr>';
								 # Artikel Ausgabe
								 while ($products = xtc_db_fetch_array($products_query)) {
								 ?>
									 <tr class="dataTableRow" onMouseOver="this.className='dataTableRowOver';this.style.cursor='pointer'" onMouseOut="this.className='dataTableRow'">
											<td class="dataTableContent txta-r" style="text-align:center;"><?php echo $products['products_id']; ?>
								      <input name="products_id[]" value="<?php echo $products['products_id']; ?>"   type="hidden">
										  </td>
										  <td class="dataTableContent txta-r"><a href="<?php echo xtc_href_link(FILENAME_CATEGORIES, "action=new_product&cPath=".$products['categories_id']."&pID=".$products['products_id']);?>" target="_blank"><strong><?php echo $products['products_name']; ?></strong></a></td>
										  <td class="dataTableContent txta-r" align="center" width="25">
											<div id="product_bild"><a href="#"><?php echo xtc_image(DIR_WS_CATALOG_THUMBNAIL_IMAGES. $products['products_image'], '', '25');?>

											<span><img src="../images/product_images/popup_images/<?php echo $products['products_image']; ?>"/></span></a>

											</div> 		
										  </td>

								 <?php
									$cols=2; # Anzahl bisheriger Spalten
									for($i=0; $i < count($CONFIG_FIELDS[TABLE_PRODUCTS]); $i++){
										if($CONFIG_FIELDS[TABLE_PRODUCTS][$i]['status']){
				                $cols++;
												$field = $CONFIG_FIELDS[TABLE_PRODUCTS][$i]['field'];
										    $input= $CONFIG_FIELDS[TABLE_PRODUCTS][$i]['input'];
										    $dropdown = "dropdown_".$field;
										    $datefield = strpos($field, "_date_");
				                $value = $products[$field];
								
										    if ($field == 'products_price' && PRICE_IS_BRUTTO == 'true' && $value > 0) {
										      $value = xtc_round($value * ((100 + xtc_get_tax_rate($products['products_tax_class_id'])) / 100), PRICE_PRECISION);
												} elseif ($datefield){
												  $value = substr($value, 0, 10);
												}
											  $align= $CONFIG_FIELDS[TABLE_PRODUCTS][$i]['align'];
				      					$style = !empty($align)?'text-align:'.$align.';':'';
				      					if($datefield && $_SESSION['access'] && $CONFIG_FIELDS[TABLE_PRODUCTS][$i]['edit']==1)
				      					   $style .= 'white-space: nowrap;';
												echo '<td class="dataTableContent txta-r" style="'.$style.'">';
												if($_SESSION['access'] && $CONFIG_FIELDS[TABLE_PRODUCTS][$i]['edit']==1) {
				                  if(isset($$dropdown)){
				                    echo xtc_draw_pull_down_menu($field.'_'.$products['products_id'], $$dropdown, $value);
				                  }elseif($datefield){
				                  ?>
														<script type="text/javascript">
														  $(function() {  /* set Datepicker  */
															$('#DatepickerProduct<?php echo $products['products_id'] ?>').datepick();
														  });
														</script>
														<?php echo xtc_draw_input_field($field.'_'.$products['products_id'], $value, "id=\"DatepickerProduct".$products['products_id']."\" style=\"width:135px\""); ?>
														
													<?php
													}elseif($input>0){
											   	  echo xtc_draw_input_field($field.'_'.$products['products_id'], $value, "style='width:".$input."px'");
													}else{
                            echo xtc_draw_checkbox_field($field.'_'.$products['products_id'], '1', ($value == '1'));
													}
												}else{
											      if (isset($$dropdown)){
															if($value > 0)
																echo getDropdownValue($$dropdown, $value);
													  } else {
                               echo $value;
														}


												}
												echo '</td>';
											}
										}
								    echo "</tr>";

									// product attributes
									$attributes_query = xtc_db_query(getStrSqlAttributes($products['products_id']));
									if(MODULE_STOCKLIST_SHOW_ATTRIBUTES_CAPTIONS == 'True' && xtc_db_num_rows($attributes_query)){
		                echo '<tr class="dataTableHeadingContent txta-r">';
										echo '<td class="dataTableHeadingContent txta-r" colspan="'.COLSPAN_ATTRIBUTES.'" style="font-weight: bold; text-align:right;">';
										echo HEADING_PRODUCTS_ATTRIBUTES_ATTRIBUTES_NAME;
										echo '</td>';
										echo '<td class="dataTableHeadingContent txta-r">';
								        echo "<span title='". HEADING_PRODUCTS_ATTRIBUTES_IMAGE ."'>".HEADING_PRODUCTS_ATTRIBUTES_IMAGE."</span>";
								        echo '</td>';										

                    $cols_attr=0;
										for($i=0; $i < count($CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES]); $i++){
											if($CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['status'] && isset($CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['field'])){
											  $cols_attr++;
											  $field = $CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['field'];
											  $caption = $CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['caption'];
											  $align= $CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['align'];
			        					$style = !empty($align)?'text-align:'.$align.';':'';
												echo '<td class="dataTableHeadingContent txta-r" style="font-weight: bold;'.$style.'">';
												echo $caption;
												echo '</td>';
											}
										}
										$totalcols = $cols-3-$cols_attr;
										if($totalcols>0)
                       echo str_repeat('<td class="dataTableHeadingContent txta-r" style="border: none;">', $totalcols);
					    			echo '</tr>';
									}

									while ($attributes = xtc_db_fetch_array($attributes_query)) {
										 $attr_price_brutto = ($attributes['options_values_price']*($tax['tax_rate']+100)/100);
										?>
									    <tr class="dataTableRow" onMouseOver="this.className='dataTableRowOver';this.style.cursor='pointer'" onMouseOut="this.className='dataTableRow'">
											<td colspan="<?php echo COLSPAN_ATTRIBUTES;?>" style="font-weight: bold; text-align:right;" class="dataTableContent txta-r">
										   <?php
                       echo xtc_draw_hidden_field('attributes_price_'.$attributes['products_attributes_id'], $attributes['options_values_price']);
											 echo $attributes['products_options_name'].":&nbsp;".$attributes['products_options_values_name']; ?>
									    <input name="attributes_id[]" value="<?php echo $attributes['products_attributes_id']; ?>"   type="hidden">
											</td>
										  <td class="dataTableContent txta-r" align="center" width="40">
	
										  </td>											
											<?php
											for($i=0; $i < count($CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES]); $i++){
												if($CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['status']){
												    if(isset($CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['field'])){
															$field = $CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['field'];
													    $input= $CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['input'];

														  $caption_constant = "HEADING_".strtoupper(TABLE_PRODUCTS_ATTRIBUTES)."_".strtoupper($field);
														  $caption_title = @constant($caption_constant);

														  $align= $CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['align'];
					          					$style = !empty($align)?'text-align:'.$align.';':'';
					                    $praefix = '';
					                    $value = $attributes[$field];
													    if($field=='options_values_price'){
																if (PRICE_IS_BRUTTO == 'true' && $value > 0)
																	$value = xtc_round($value * ((100 + xtc_get_tax_rate($products['products_tax_class_id'])) / 100), PRICE_PRECISION);
																$praefix = $value>0 && (!$_SESSION['access'] || $CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['edit']!=1)?$attributes['price_prefix']:'';
					                    	$value = $value>0?$value:'';
															}
														} else{
															# Leerspalte
															$value = '&nbsp;xxx';
															$style = '';
															$praefix = '';
														}
														echo '<td class="dataTableContent txta-r" style="'.$style.'">'.$praefix;

														if($_SESSION['access'] && $CONFIG_FIELDS[TABLE_PRODUCTS_ATTRIBUTES][$i]['edit']==1) {
															if($input>0){
													   	  echo xtc_draw_input_field($field.'_'.$attributes['products_attributes_id'], $value, "style='width:".$input."px'");
															}else{
															  echo xtc_draw_checkbox_field($field.'_'.$attributes['products_attributes_id'], '1', ($value == '1'));
															}
														} else {
																echo $value;
														}
														echo '</td>';
												}
											}
											$totalcols = $cols-3-$cols_attr;
										  if($totalcols>0)
											   echo str_repeat('<td class="dataTableContent txta-r">&nbsp;</td>', $totalcols);
											?>
										</tr>
										<?php
										} // end while attributes
								 }  // while end product loop
								 ?>
				        </tr>
								</table>
							</td>
	          </tr>
	           </form>
		        <tr>
		          <td class="smallText" align="center" style="padding:5px;" colspan="<?php echo (5 + EDIT_MODE); ?>" >
		          <span style="padding-right:50px;"><?php echo $products_split->display_count($products_query_numrows, $_SESSION['paging'], $_SESSION['page'], TEXT_DISPLAY_NUMBER_OF_PRODUCTS); ?></span>
		          <?php  echo $products_split->display_links($products_query_numrows, $_SESSION['paging'], MAX_DISPLAY_PAGE_LINKS, $_SESSION['page'], xtc_get_all_get_params(array('page', 'action', 'paging', 'sorting')) .$PARAMS_URL."&sorting=".$_SESSION['sorting']."&paging=".$_SESSION['paging'] ); ?>
		          </td>
		        </tr>

	         </table>

					</td>
				<!-- body_text_eof //-->
			</tr>
		</table>
		<!-- body_eof //-->
		<!-- footer //-->
        <?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
		<!-- footer_eof //-->
	</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>